/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.domain.hotspot;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.util.c;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="operator")
public class Operator {
    @Id
    private String id;
    @Indexed(unique=true)
    @Pattern(regexp="^[a-zA-Z0-9_-]{4,32}$", message="Operator name should be between 4 and 32 characters with the combination of letters, digits, hyphens or underlines.")
    private String name;
    private String password;
    @Length(max=64, message="Max length of note is 64 characters.")
    private String note;
    private Long createdTime;
    private String roleName;
    private String lastSite;
    @DBRef
    private Role role;

    public String getLastSite() {
        return this.lastSite;
    }

    public void setLastSite(String lastSite) {
        this.lastSite = lastSite;
    }

    public String toString() {
        return "Operator{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", password='" + this.password + '\'' + ", note='" + this.note + '\'' + ", createdTime=" + this.createdTime + ", roleName='" + this.roleName + '\'' + ", role=" + this.role + ", lastSite='" + this.lastSite + '\'' + '}';
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return c.d(this.password);
    }

    public void setPassword(String password) {
        this.password = c.c(password);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
    }

    @JsonIgnore
    public String getPlainPassword() {
        return this.password;
    }
}

